<?php
    $sf_options = sf_get_theme_opts();
	
    $blog_type      = $sf_options['archive_display_type'];
	$blog_classes 	= sf_blog_classes( $blog_type );
    $columns   		= 4;
    $pagination 	= "standard";
    $pagination_output = "";
    if ( isset($sf_options['archive_display_columns']) ) {
    $columns   = $sf_options['archive_display_columns'];
    }
    if ( isset($sf_options['archive_display_pagination']) ) {
    $pagination   = $sf_options['archive_display_pagination'];
    }
    $content_output = $sf_options['archive_content_output'];
	$item_class 	= $blog_classes['item'];
	$show_read_more = "no";
	
    // Enqueue script
    if ( $blog_type == "masonry" ) {
    	wp_enqueue_script( 'isotope' );
	}
?>

<div class="blog-wrap blog-items-wrap blog-<?php echo esc_attr($blog_type); ?>">

	<?php if ( have_posts() ) : ?>
	
	        <?php if ( $blog_type == "timeline" ) { ?>
	            <div class="timeline"></div>
	        <?php } ?>
	
	        <!-- OPEN .blog-items -->
	        <ul class="blog-items row <?php echo esc_attr($blog_classes['list']); ?> clearfix"
	            data-blog-type="<?php echo esc_attr($blog_type); ?>">
	
	            <?php while ( have_posts() ) : the_post(); ?>
	
	                <?php
	                $post_format = get_post_format( $post->ID );
	                if ( $post_format == "" ) {
	                    $post_format = 'standard';
	                }
	                ?>
	                <li <?php post_class( 'blog-item ' . $item_class . ' format-' . $post_format ); ?> itemscope itemtype="http://schema.org/BlogPosting">

                        <?php
                            $sf_options = sf_get_theme_opts();

                            $post_author     = get_the_author();
                            $post_date       = get_the_date();

                            $thumb_type         = sf_get_post_meta( $post->ID, 'sf_thumbnail_type', true );

                            $post_item = sf_get_searched_post( $post->ID, "yes", "yes", "yes", $show_read_more, $content_output, "20" );

                            // Meta
                            $post_item .= '<meta itemprop="datePublished" content="' . get_the_date( 'Y-m-d' ) . '"/>';
                            $post_item .= '<meta itemprop="dateModified" content="' . get_the_modified_date( 'Y-m-d' ) . '"/>';
                            $post_item .= '<div class="hidden vcard author">'. sprintf(__('<span itemprop="author" class="fn">%1$s</span>', 'swiftframework'), $post_author, $post_date) .'</div>';
                            $logo = $logo_src = $logo_width = $logo_height = "";
                            if ( isset( $sf_options['logo_upload'] ) ) {
                                $logo = $sf_options['logo_upload'];
                            }
                            if ( isset( $logo['url'] ) ) {
                                $logo_src = $logo['url'];
                            }
                            if ( isset( $logo['width'] ) ) {
                                $logo_width = $logo['width'];
                            }
                            if ( isset( $logo['height'] ) ) {
                                $logo_height = $logo['height'];
                            }
                            $post_item .= '<div itemprop="publisher" itemscope="" itemtype="https://schema.org/Organization">
                                    <div itemprop="logo" itemscope="" itemtype="https://schema.org/ImageObject" style="display:none;">
                                        <img src="' . $logo_src . '" />
                                        <meta content="' . $logo_src . '" itemprop="url" />
                                        <meta content="' . $logo_width . '" itemprop="width" />
                                        <meta content="' . $logo_height . '" itemprop="height" />
                                    </div>
                                    <meta itemprop="name" content="' . get_bloginfo('name'). '" />
                                </div>';

                            echo $post_item;
                        ?>

	                </li>
	
	            <?php endwhile; ?>
	
	            <!-- CLOSE .blog-items -->
	        </ul>
	
	
	
	<?php else: ?>
	
	    <h3><?php _e( 'Sorry, there are no results to display.', 'uplift' ); ?></h3>
	    
	    <div class="no-results-text">
            <p><?php _e( 'Please use the form below to search again.', 'uplift' ); ?></p>
    
            <form method="get" class="search-form" action="<?php echo home_url(); ?>/">
                <input type="text" placeholder="<?php _e( 'Search', 'uplift' ); ?>" name="s"/>
            </form>
            <p><?php _e( 'Alternatively, you can browse the sitemap below.', 'uplift' ); ?></p>
            <?php echo do_shortcode( '[sf_sitemap]' ); ?>
        </div>

	<?php endif; ?>
        
	<?php if ( $pagination == "infinite-scroll" ) {
	
	    $pagination_output .= '<div class="pagination-wrap hidden infinite-scroll-enabled">';
	    $pagination_output .= pagenavi( $wp_query );
	    $pagination_output .= '</div>';
	
	} else if ( $pagination == "load-more" ) {
		
	    $pagination_output .= '<a href="#" class="load-more-btn">' . __( 'Load More', 'uplift' ) . '</a>';
	
	    $pagination_output .= '<div class="pagination-wrap load-more hidden infinite-scroll-enabled">';
	    $pagination_output .= pagenavi( $wp_query );
	    $pagination_output .= '</div>';
	
	} else if ( $pagination == "standard" ) {
	    if ( $blog_type == "masonry" ) {
	        $pagination_output .= '<div class="pagination-wrap masonry-pagination">';
	    } else {
	        $pagination_output .= '<div class="pagination-wrap">';
	    }
	    $pagination_output .= pagenavi( $wp_query );
	    $pagination_output .= '</div>';
	}
	echo $pagination_output;
	?>

</div>